//
//  CRLayer.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/20/11.
//  Copyright 2011 Neatberry. All rights reserved.
//

#import "CRSceneItemVisual.h"

@class CRCICanvas;
@class CRInplaceEditorController;

extern NSString* const CRLayerNameKey;
extern NSString* const CRLayerVisibleKey;
extern NSString* const CRLayerFilterKey;

//////////////////////////////////////////////////////////////////////
// Graphics layer
//////////////////////////////////////////////////////////////////////
@interface CRLayer : CRSceneItemVisual
{
	CRCICanvas*					mask;
	
@protected
	CRSceneItemVisual*			filter;
	CRInplaceEditorController*	maskEditorController;
}

@property (nonatomic, strong) NSString*				name;
@property (nonatomic, assign) BOOL					visible;
@property (nonatomic, strong) CRSceneItemVisual*	filter;
@property (nonatomic, strong) CRCICanvas*			mask;

+ (id)layer;

// filter
- (id)defaultFilter;

// masks
- (CRCICanvas *)canvas;
- (void)updateMask:(id)root;
- (CRInplaceEditorController *)maskEditorController;

@end